#============================================================================== 
# ** Ruby.String
#------------------------------------------------------------------------------
# Description:
# ------------
# Miscellaneous New stuff for the String class.
#  
# Method List:
# ------------
# clear
# get_int
# get_ints
# seph_encrypt
# seph_encrypt!
# seph_decrypt
# seph_decrypt!
# to_filename
# to_filename!
#==============================================================================

MACL::Loaded << 'Ruby.String'

#============================================================================== 
# ** String     
#==============================================================================

class String
  #-------------------------------------------------------------------------
  # * Name      : Clear
  #   Info      : Removes string characters and returns self
  #   Author    : SephirothSpawn
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def clear
    slice!(0, self.size)
  end
  #-------------------------------------------------------------------------
  # * Name      : Get Integer
  #   Info      : Gets the Integer from String
  #   Author    : Trickster
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def get_int
    m = self.gsub(/\D/,'')
    return m.to_i
  end
  #-------------------------------------------------------------------------
  # * Name      : Get Integers
  #   Info      : Gets all Integers from String
  #   Author    : Trickster
  #   Call Info : No Arguments 
  #-------------------------------------------------------------------------
  def get_ints
    array = self.split(/\D/)
    array.collect! {|item| item.to_i}
    return array
  end
  #-------------------------------------------------------------------------
  # * Name      : Seph Encrypt
  #   Info      : Returns an encrypted version of a string with a keyword
  #   Author    : SephirothSpawn
  #   Call Info : Encryption Word String
  #-------------------------------------------------------------------------
  def seph_encrypt(encryption_string = 'encrypt')
    # Collects Encryption String Bytes
    encryption_bytes = []
    encryption_string.each_byte {|c| encryption_bytes << c}
    # Creates New String
    string = ''
    # Pass Through Self
    for i in 0...self.size
      # Gets Encrypted Byte
      byte = self[i] * encryption_bytes[i % encryption_bytes.size]
      # Gets Base & Mod Value
      base, mod = byte / 255, byte % 255
      # Adds Encrypted Character
      string += base.chr + mod.chr
    end
    # Returns Encryption String
    return string
  end
  #-------------------------------------------------------------------------
  # * Name      : Seph Encrypt!
  #   Info      : Encrypts self with a keyword. Returns modified self.
  #   Author    : SephirothSpawn
  #   Call Info : Encryption Word String
  #-------------------------------------------------------------------------
  def seph_encrypt!(encryption_string = 'encrypt')
    # Gets Encryption String
    encrypted_string = seph_encrypt(encryption_string)
    # Clears self
    clear
    # Makes self encrypted string
    self.concat(encrypted_string)
    # Returns Decrypted String
    return self
  end
  #-------------------------------------------------------------------------
  # * Name      : Seph Decrypt
  #   Info      : Returns an decrypted version of a string with a keyword
  #   Author    : SephirothSpawn
  #   Call Info : Encryption Word String
  #-------------------------------------------------------------------------
  def seph_decrypt(encryption_string = 'encrypt')
    # Collects Encryption String Bytes
    encryption_bytes = []
    encryption_string.each_byte {|c| encryption_bytes << c}
    # Creates New String
    string = ''
    # Pass Through Self
    for i in 0...(self.size / 2)
      # Gets Base & Mod Value
      b, m = self[i * 2] * 255, self[i * 2 + 1]
      # Gets New Character
      string += ((b + m) / encryption_bytes[i % encryption_bytes.size]).chr
    end
    # Returns Decrypted String
    return string
  end
  #-------------------------------------------------------------------------
  # * Name      : Seph Decrypt
  #   Info      : Decrypts a string with keyword. Returns modified self.
  #   Author    : SephirothSpawn
  #   Call Info : Encryption Word String
  #-------------------------------------------------------------------------
  def seph_decrypt!(encryption_string = 'encrypt')
    # Gets Decrypted String
    decrypted_string = seph_decrypt(encryption_string)
    # Clears self
    clear
    # Makes self encrypted string
    self.concat(decrypted_string)
    # Returns Decrypted String
    return self
  end
  #-------------------------------------------------------------------------
  # * Name      : To Filename
  #   Info      : Converts the string to a filename
  #   Author    : Trickster
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def to_filename
    string = self.clone
    string.downcase!
    string.gsub!(/\s/,'_')
    return string
  end
  #-------------------------------------------------------------------------
  # * Name      : To Filename!
  #   Info      : Modifies Itself Converts the string to a filename
  #   Author    : Trickster
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def to_filename!
    string = self.clone
    self.downcase!
    self.gsub!(/\s/,'_')
    return string == self ? nil : self
  end
end